up_key = keyboard_check_pressed(vk_up);
down_key = keyboard_check_pressed(vk_down);
accept_key = keyboard_check_pressed(vk_enter);

// Update option length for the current menu level
op_length = array_length(option[menu_level]);

// Navigate through options
pos += down_key - up_key;
if pos >= op_length { pos = 0; }
if pos < 0 { pos = op_length - 1; }

// Handle option selection
if accept_key {
    var _sml = menu_level;

    switch (menu_level) {
        case 0: // Pause Menu
            switch (pos) {
                case 0: keyboard_key_press(ord("P")); break; // Resume
                case 1: save_game(); break; // Save Game
                case 2: menu_level = 1; break; // Settings
                case 3: room_goto(rmTitle_Menu); break; // Main Menu
            }
            break;

        case 1: // Settings Menu
            switch (pos) {
                case 0: menu_level = 2; break; // Window size submenu
                case 1: menu_level = 3; break; // Controls submenu
                case 2: menu_level = 4; break; // Objective submenu
                case 3: menu_level = 0; break; // Back to pause menu
            }
            break;

        case 2: // Window Size Submenu
            switch (pos) {
                case 0:
                    if (option[2, 0] == "Window Size: 1x") {
                        option[2, 0] = "Window Size: 2x";
                        window_set_size(1024, 768);
                    } else if (option[2, 0] == "Window Size: 2x") {
                        option[2, 0] = "Window Size: 3x";
                        window_set_size(1536, 1024);
                    } else if (option[2, 0] == "Window Size: 3x") {
                        option[2, 0] = "Window Size: 1x";
                        window_set_size(864, 648);
                    }
                    break;
                case 1:
                    global.fullscreen_enabled = !global.fullscreen_enabled;
                    window_set_fullscreen(global.fullscreen_enabled);
                    break;
                case 2: menu_level = 1; break; // Back to settings
            }
            break;

        case 3: // Controls Submenu
            if (pos == 4) menu_level = 1; // Back to settings
            break;

        case 4: // Objective Submenu
            if (pos == 1) menu_level = 1; // Back to settings
            break;
    }

    if _sml != menu_level { pos = 0; } // Reset position when changing menu
    op_length = array_length(option[menu_level]); // Update option length
}
